unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, LibXmlParser, LibXmlComps;

type
  TForm1 = class(TForm)
    XmlScanner1: TXmlScanner;
    Memo1: TMemo;
    Button1: TButton;
    procedure XmlScanner1StartTag(Sender: TObject; TagName: String;
      Attributes: TAttrList);
    procedure Button1Click(Sender: TObject);
    procedure XmlScanner1Content(Sender: TObject; Content: String);
  private
  public
   CurrentElement : string;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.XmlScanner1StartTag(Sender: TObject; TagName: String;
  Attributes: TAttrList);
begin
  Memo1.Lines.Add ('Start Tag: ' + TagName);
  CurrentElement := TagName;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  XmlScanner1.Execute;
end;

procedure TForm1.XmlScanner1Content(Sender: TObject; Content: String);
begin
  Memo1.Lines.Add ('Content ['+CurrentElement+']: ' + Content);
end;

end.
